Option Explicit

Rem Anpassung un Erweiterung (von Florian Behrendt)
Rem Version 1.01
Rem Stand: 08.02.1998

Const max_Faders = 5 ' Anzahl der Fader weniger 1 wegen Element Null

Rem DLL-Deklarationen zur DLL SLHDMX1.DLL
Rem Declarations of the 16Bit DLL SLHDMX1.DLL

Rem SLH-DMX-Funktionen fr Interfacekarte 1512A/1512B/1512C
Rem Functions for PC Interface Cards 1512A/1512B/1512C

Declare Function vbCardadr% Lib "SLHDMX2.DLL" (ByVal Egal%)
'Adresse der DMX-Karte im Rechner ermitteln
'Checks for presence of card, returns the card address
'Rckgabewert: Kartenadresse
'Aufrufwert: beliebig (egal)
'calling parameter: (any value)

Declare Sub vbWOS Lib "SLHDMX2.DLL" (ByVal Kartenadresse%, ByVal MHz%)
'Kopiert das Betriebssystem fr den Kartenprozessor in die Karte.
'Aufruf mit Parameter MHz%=12 oder MHz%=16 je nach Quartz der Karte
'Copies the Card Processor Operating System to the Card Memory.
'Call with parameter MHz%=12 or MHz%=16 depending on card crystal.

Declare Sub vbWByte Lib "SLHDMX2.DLL" (ByVal Kartenadresse%, ByVal RAM%, ByVal Wert%)
'Schreibt einen Wert in die DMX-Karte mit der angegebenen Kartenadresse,
'an die angebene RAM-Adresse innerhalb der Karte.
'Die RAM-Adrebelegung ist an anderer Stelle beschrieben.
'Writes a value to the card at the specified card address; the value
'will be written into the specified Card RAM location.
'See the manual for Card RAM specification

Declare Function vbRByte% Lib "SLHDMX2.DLL" (ByVal Kartenadresse%, ByVal RAM%)
'Liest einen Wert aus der DMX-Karte mit der angegebenen Kartenadresse,
'aus der angebenen RAM-Adresse innerhalb der Karte.
'Die RAM-Adrebelegung ist an anderer Stelle beschrieben.
'Reads a value from the card at the specified card address; the value
'is read from the specified Card RAM location.
'See the manual for Card RAM specification

Declare Function vbdmxstart% Lib "SLHDMX2.DLL" (ByVal Kartenadresse%)
'Startet die bertragung der DMX-Karte
'starts the DMX transmission. Calling parameter=Card Address, Return parameter=dummy

Declare Function vbDMXStop% Lib "SLHDMX2.DLL" (ByVal Kartenadresse%)
'Beendet die bertragung der DMX-Karte
'stops the DMX transmission. Calling parameter=Card Address, Return parameter=dummy



Rem SLH-DMX-Funktionen fr Printerort-Interface
Rem Functions for PrinterPort Interface DMXPCP
Declare Sub vBPByte Lib "SLHDMX2.DLL" (ByVal Port%, ByVal Wert%)
'Schreibt ein Byte Wert% in den PrinterPort mit der Adresse Port%
'Writes a byte WERT% to the printer port with the address PORT%

Declare Function vBPrByte% Lib "SLHDMX2.DLL" (ByVal Port%, ByVal Wert%)
'Schreibt ein Byte Wert% in den PrinterPort mit der Adresse Port%
'Rckgabewert 0 bei erfolgreichem Transfer, <>0 bei Fehler
'(z.B. Interface nicht ansprechbar)
'Writes a byte WERT% to the printer port with the address PORT%
'and returns a value =0 if succesful, <>0 if not successful
'(e.g. interface not present or buffer overrun)


'------------------------------------------------------------------
'Die folgenden Variablen sind fr die Beispielprogramme deklariert
'Declaration of variables for the demo programs
'------------------------------------------------------------------
Global i As Integer, n As Integer       ' allgemeine Indexvariablen
                                        ' general public indices

Global DMXAUSGABE(0 To max_Faders)  As Integer   ' Ausgabewert
                                        ' DMX Output Value

Global DMXOUT(0 To 512) As Integer      ' DMX-Datenarray
                                        ' DMX Data Array

Global AlterWert As Integer             ' Merkregister
Global AlterUWert As Integer            ' Scratchpad

'neu hinzu:

Global Memory(0 To max_Faders, 0 To max_Faders) As Integer
Global STOFLG As Integer                'Merkflag: "Speichern"


'------------------------------------------------------------------
'variables for PC-card
'------------------------------------------------------------------
'required:
Global cardadr As Integer               ' word: Kartenadresse im PC
                                        ' word: card address
Global dmxdef(0 To 9) As Integer        ' Hardware-Initialisierungswerte
                                        ' parameters for hardware initialization (see manual)
'------------------------------------------------------------------
'variables for PrinterPort Interface
'------------------------------------------------------------------
'required:
Global PCPADR As Integer                ' Port-Adresse

'optional:
Global PCP$                             ' PrinterPort Name
Global PCPSTART As Integer              ' Startflag 2=start 1=stop

